#!/bin/sh
sleep 5

setsid /opt/NXServer/bin/SystemRead > /opt/sys.log

DeviceName="PX"   

BATTERY_Server="/opt/Function/Power/battery*"
ETH_Server="/opt/Function/ETH_Server/ETH_server*"

echo "install Net"

log="/opt/Function/Net/v4.log"
Net="/opt/Function/Net/"
v4Config="IPAddr_V4.config"
v4Path="${Net}/${v4Config}"

RUNNING_INSTANCES=$(ps -ef | grep Res_ | grep -v grep)

INSTANCE_COUNT=$(echo "$RUNNING_INSTANCES" | wc -l)

if [ "$INSTANCE_COUNT" -gt 2 ]; then
  exit 1
fi


while true
do
	sleep 1

	NetLo=""
	
	if [ ! -f "/home/rpdzkj/otg.config" ]; then
		command="ifconfig | grep -v lo"

		args=$(iw dev | grep Interface | awk '{print $2}')

		for arg in $args; do
			command="$command | grep -v $arg"
		done

		netName=$(eval $command | awk -F' ' '{print $1}')

		NetLo=$(echo $netName | awk -F':' '{print $1}') 
	else
		NetLo="usb0"
		sudo ifconfig usb0 up
	fi

	BATTERY=$(ps -ef | grep battery* | grep -v grep | awk '{print $2}')

	if [ -n "$BATTERY" ];then
		sleep 0.1
	else
		sudo setsid $BATTERY_Server &
	fi

	# echo "eth_run $ETH_RUN ---1"

	if [ -z "$NetLo" ]; then
		
		sleep 0.5
		if [ -n "$ETH_RUN" ]; then
			sleep 0.1
		else
			kill $ETH_RUN
		fi
		echo "log Waing : net close" >> $log
		sudo  ip addr flush dev $NetLo
	else

		NetConnect=$(ifconfig $NetLo| grep RUNNING)	
		
		# echo "NetConnect $NetConnect ---2"
		
		if [ -z "$NetConnect" ]; then
			if [ -n "$ETH_RUN" ]; then
				sleep 0.1
			else
				kill $ETH_RUN
			fi

			sudo  ip addr flush dev $NetLo
			echo "ip addr flush dev" >> $log
		else
			sleep 3
			net=$(ifconfig $NetLo | grep netmask)

			if [ -z "$net" ]; then
  				sudo  route add -host 255.255.255.255 dev $NetLo
  				sleep 0.5
				sudo  ps -ef | grep Net | grep -v grep | awk '{print $2}' | xargs kill -9
				if [ -f "/home/rpdzkj/Net/IPAddr_V4.config" ]; then
						echo "into"
						echo $v4Path
						while IFS= read -r line || [ -n "$line" ]
						do
						echo "Line read: $line"
						sudo  ip addr add "$line" dev "$NetLo"
						if [ $? -ne 0 ]; then
							echo "Failed to add IP address: $line"
						fi
						done < "$v4Path"
						echo "ip addr add dev" >> $log
				else
					sudo  ip addr add 192.168.1.100/24 dev "$NetLo"
				fi
				sudo arp-scan --localnet
			fi

			sudo  route add -host 255.255.255.255 dev $NetLo
			sudo arp-scan --localnet

			ETH_RUN=$(ps -ef | grep ETH | grep -v grep | awk '{print $2}')

			if [ -n "$ETH_RUN" ];then
				sleep 0.1
			else
				sudo $ETH_Server &
			fi

			PXConfig_zi=$(ls /opt | grep .*PXConfig.\*.zip)

			echo ${PXConfig_zi}

			if [ -f "/opt/PX_update.txt" ]; then

				old_PXConfig=$(ls /opt | grep -v .*PXConfig.\*.zip | grep -v .*PXConfig.\*.deb | grep .*PXConfig.\*)
			
				echo ${old_PXConfig}
				# sudo rm -r /opt/${old_PXConfig}

				sudo mv /opt/${old_PXConfig}  /opt/oldConfig

				sudo unzip /opt/${PXConfig_zi} -d /opt/
				
				new_PXConfig=$(ls /opt | grep -v .*PXConfig.\*.zip | grep .*PXConfig.\*)

				sudo sh /opt/${new_PXConfig}/update.sh

				sudo rm /opt/${PXConfig_zi}

				sleep 1
			fi

			if [ -f "/root/NX_update.txt" ]; then
				kill -9 $ETH_RUN
				sudo rm -r /opt/NXServer/

				sudo unzip -o /opt/NXServer.zip -d /opt/ 

				sudo setsid sh /opt/NXServer/update.sh &
				
				sleep 1
				sudo rm /opt/NXServer.zip
				exit 0
			fi
		fi
	fi
done
