#!/bin/sh
# tcp_optimize_temp.sh
# Temporary TCP optimization (not persistent after reboot)

set -e

echo ">>> Optimizing TCP parameters (temporary)..."

# Keepalive and retries
sysctl -w net.ipv4.tcp_keepalive_time=60
sysctl -w net.ipv4.tcp_keepalive_intvl=60
sysctl -w net.ipv4.tcp_keepalive_probes=60
sysctl -w net.ipv4.tcp_retries2=100

# TCP buffer sizes
sysctl -w net.ipv4.tcp_rmem="8192 87380 536870912"
sysctl -w net.ipv4.tcp_wmem="8192 65536 536870912"

# Global socket buffer limits
sysctl -w net.core.rmem_max=536870912
sysctl -w net.core.wmem_max=536870912

echo ">>> TCP optimization applied (temporary)."
