% Configure the compilation environment
% setenv('MW_MINGW64_LOC','D:\msys64\ucrt64');
% mex -setup C++

% Load htra_api.dll
if not(libisloaded('htra_api.dll'))   
    try
        % Attempt to load the DLL and its header file
        loadlibrary('.\htra_api\htra_api.dll','.\htra_api\htra_api.h'); 
    catch ME
        % Catch any errors during the loading process; ME is an MException object containing details
        fprintf('Failed to load htra_api.dll or htra_api.h: %s\n', ME.message);
        
        % End the program; please check whether htra_api.dll or htra_api.h exists in the htra_api folder in the same directory as this .m file.
        % If not, please copy these files from "Materials\Windows\HTRA_API\x64\htra_api" into the htra_api folder beside the .m file.
        fprintf('The program will end, please check whether the file path and file exist.\n');
        
        return;
        % End the current function or script
    end
end

libfunctions('htra_api'); % View all functions in the API

% Build the target folder path
folderPath = fullfile(pwd, 'htra_api_mat');

% Check if the folder exists; if not, create it
if ~exist(folderPath, 'dir')
    mkdir(folderPath);  % Create the target folder
end

% Create a BootProfile structure
BootProfile = libstruct('BootProfile_TypeDef'); 
save(fullfile(folderPath,'BootProfile.mat'), 'BootProfile');

% Create the DeviceInfo structure
DeviceInfo = libstruct('DeviceInfo_TypeDef');
save(fullfile(folderPath,'DeviceInfo.mat'), 'DeviceInfo');

% Create the DeviceState_TypeDef structure
DeviceState = libstruct('DeviceState_TypeDef');
save(fullfile(folderPath,'DeviceState.mat'), 'DeviceState');

% Create the BootInfo_TypeDef structure
BootInfo = libstruct('BootInfo_TypeDef');
save(fullfile(folderPath,'BootInfo.mat'), 'BootInfo');

% Create the GNSSInfo_TypeDef structure
GNSSInfo = libstruct('GNSSInfo_TypeDef');
save(fullfile(folderPath,'GNSSInfo.mat'), 'GNSSInfo');

% Create the SWP_Profile_TypeDef structure
SWP_Profile = libstruct('SWP_Profile_TypeDef');
save(fullfile(folderPath,'SWP_Profile.mat'), 'SWP_Profile');

% Create the SWP_TraceInfo_TypeDef structure
TraceInfo = libstruct('SWP_TraceInfo_TypeDef');
save(fullfile(folderPath,'TraceInfo.mat'), 'TraceInfo');

% Create the MeasAuxInfo_TypeDef structure
MeasAuxInfo = libstruct('MeasAuxInfo_TypeDef');
save(fullfile(folderPath,'MeasAuxInfo.mat'), 'MeasAuxInfo');

% Create the IQS_Profile_TypeDef structure
IQS_Profile = libstruct('IQS_Profile_TypeDef');
save(fullfile(folderPath,'IQS_Profile.mat'), 'IQS_Profile');

% Create the IQS_StreamInfo_TypeDef structure
IQS_StreamInfo = libstruct('IQS_StreamInfo_TypeDef');
save(fullfile(folderPath,'IQS_StreamInfo.mat'), 'IQS_StreamInfo');

% Create the IQStream_TypeDef structure
IQStream = libstruct('IQStream_TypeDef');
save(fullfile(folderPath,'IQStream.mat'), 'IQStream');

% Create the IQS_TriggerInfo_TypeDef structure
TriggerInfo = libstruct('IQS_TriggerInfo_TypeDef');
save(fullfile(folderPath,'TriggerInfo.mat'), 'TriggerInfo');

% Create the DET_Profile_TypeDef structure
DET_Profile = libstruct('DET_Profile_TypeDef');
save(fullfile(folderPath,'DET_Profile.mat'), 'DET_Profile');

% Create the DET_StreamInfo_TypeDef structure
DET_StreamInfo = libstruct('DET_StreamInfo_TypeDef');
save(fullfile(folderPath,'DET_StreamInfo.mat'), 'DET_StreamInfo');

% Create the RTA_Profile_TypeDef structure
RTA_Profile = libstruct('RTA_Profile_TypeDef');
save(fullfile(folderPath,'RTA_Profile.mat'), 'RTA_Profile');

% Create the RTA_FrameInfo_TypeDef structure
RTA_FrameInfo = libstruct('RTA_FrameInfo_TypeDef');
save(fullfile(folderPath,'RTA_FrameInfo.mat'), 'RTA_FrameInfo');

% Create the RTA_PlotInfo_TypeDef structure
RTA_PlotInfo = libstruct('RTA_PlotInfo_TypeDef');
save(fullfile(folderPath,'RTA_PlotInfo.mat'), 'RTA_PlotInfo');

% Create the RTA_TriggerInfo_TypeDef structure
RTA_TriggerInfo = libstruct('IQS_TriggerInfo_TypeDef');
save(fullfile(folderPath,'RTA_TriggerInfo.mat'), 'RTA_TriggerInfo');

% Create the DSP_FFT_TypeDef structure
DSP_FFT = libstruct('DSP_FFT_TypeDef');
save(fullfile(folderPath,'DSP_FFT.mat'), 'DSP_FFT');

% Create the ASG_Profile_TypeDef structure
ASG_Profile = libstruct('ASG_Profile_TypeDef');
save(fullfile(folderPath,'ASG_Profile.mat'), 'ASG_Profile');

% Create the ASG_Info_TypeDef structure
ASG_Info = libstruct('ASG_Info_TypeDef');
save(fullfile(folderPath,'ASG_Info.mat'), 'ASG_Info');

clear all;

% Unload the library
unloadlibrary('htra_api');   
disp('htra_api unloaded successfully')
