﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HTRA_CSharp_Examples
{
    class ASG_CWOutput
    {
		public void Example()
		{
			#region 1 Open device

			int Status = 0;              //Return value of the function
			IntPtr Device = IntPtr.Zero; //Memory address of the current device.
			int DevNum = 0;              //Specify the device number

			HtraApi.BootProfile_TypeDef BootProfile = new HtraApi.BootProfile_TypeDef(); //Boot configuration structure,including physical interface,power supply method,etc.
			HtraApi.BootInfo_TypeDef BootInfo = new HtraApi.BootInfo_TypeDef();          //Boot information structure,including device number、USB rate,etc.

			BootProfile.DevicePowerSupply = HtraApi.DevicePowerSupply_TypeDef.USBPortAndPowerPort; //Use USB data port and seperate power port for dual power supply.

			// When the device data interface is USB, run directly.If it's Ethernet,change #if true to #if false
#if true
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.USB;
#else
			//Configure network-related parameters
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.ETH;
			BootProfile.ETH_IPVersion = HtraApi.IPVersion_TypeDef.IPv4;
			BootProfile.ETH_RemotePort = 5000;
			BootProfile.ETH_ReadTimeOut = 5000;
			BootProfile.ETH_IPAddress[0] = 192;
			BootProfile.ETH_IPAddress[1] = 168;
			BootProfile.ETH_IPAddress[2] = 1;
			BootProfile.ETH_IPAddress[3] = 100;
#endif

			Status = HtraApi.Device_Open(ref Device, DevNum, ref BootProfile, ref BootInfo); //Open device

			if (Status == 0)
			{
				System.Console.WriteLine("Device is opened successfully");
			}

			/*If the device fails to open,return an error message.If the following errors occur,the device cannot operate normally.It is recommended to follow the instructions and reopen the device.*/
			else
			{
				switch (Status)
				{
					case HtraApi.APIRETVAL_ERROR_BusOpenFailed:
						System.Console.WriteLine("Error - Check the device power supply, data cable connection and driver installation");
						return;

					case HtraApi.APIRETVAL_ERROR_RFACalFileIsMissing:
						System.Console.WriteLine("Error - RF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_IFACalFileIsMissing:
						System.Console.WriteLine("Error - IF calibration file is missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceConfigFileIsMissing:
						System.Console.WriteLine("Error - Configuration file missing");
						return;

					case HtraApi.APIRETVAL_ERROR_DeviceSpecFileIsMissing:
						System.Console.WriteLine("Error - Device specification file is missing");
						return;

					default:
						System.Console.WriteLine("Return other errors! Status = " + Status);
						return;
				}
			}
			#endregion

			#region 2 Configure parameters
			HtraApi.SWP_Profile_TypeDef SWP_ProfileIn = new HtraApi.SWP_Profile_TypeDef();  //SWP input configuration, including start frequency,stop frequency,RBW,reference level,etc.
			HtraApi.SWP_Profile_TypeDef SWP_ProfileOut = new HtraApi.SWP_Profile_TypeDef(); //SWP output configuration.
			HtraApi.SWP_TraceInfo_TypeDef TraceInfo = new HtraApi.SWP_TraceInfo_TypeDef();  //Trace information under current configuration,including trace points,hop frequency points,etc.

			HtraApi.SWP_ProfileDeInit(ref Device, ref SWP_ProfileIn); //Initialize the related parameters for SWP mode and configuration.

			SWP_ProfileIn.StartFreq_Hz = 1e9; //Configure start frequency
			SWP_ProfileIn.StopFreq_Hz = 2e9;  //Configure stop frequency

			Status = HtraApi.SWP_Configuration(ref Device, ref SWP_ProfileIn, ref SWP_ProfileOut, ref TraceInfo); // Apply the SWP mode configuration.

			HtraApi.ASG_Profile_TypeDef ASG_ProfileIn = new HtraApi.ASG_Profile_TypeDef();  //ASG input configuration, including signal source output mode, frequency, power settings, etc.
			HtraApi.ASG_Profile_TypeDef ASG_ProfileOut = new HtraApi.ASG_Profile_TypeDef(); //ASG output configuration.
			HtraApi.ASG_Info_TypeDef ASG_Info = new HtraApi.ASG_Info_TypeDef();             //Information about the number of scan points under the current configuration.

			HtraApi.ASG_ProfileDeInit(ref Device, ref ASG_ProfileIn); //Initialize the related parameters for ASG mode configuration

			//CW Signal (Single Tone)
			ASG_ProfileIn.CenterFreq_Hz = 1.51e9;
			ASG_ProfileIn.Level_dBm = -20;
			ASG_ProfileIn.Mode = HtraApi.ASG_Mode_TypeDef.ASG_FixedPoint;
			ASG_ProfileIn.Port = HtraApi.ASG_Port_TypeDef.ASG_Port_Internal;

			//Frequency sweep signal
			/*ASG_ProfileIn.StartFreq_Hz = 1.2e9;
            ASG_ProfileIn.StopFreq_Hz = 1.4e9;
            ASG_ProfileIn.StepFreq_Hz = 1e6;
            ASG_ProfileIn.Level_dBm = -20;
            ASG_ProfileIn.Mode = HtraApi.ASG_Mode_TypeDef.ASG_FrequencySweep;*/

			//Power sweep signal
			/*ASG_ProfileIn.CenterFreq_Hz = 1.6e9;
            ASG_ProfileIn.StartLevel_dBm = -30;
            ASG_ProfileIn.StopLevel_dBm = -20;
            ASG_ProfileIn.Mode = HtraApi.ASG_Mode_TypeDef.ASG_PowerSweep;*/

			HtraApi.ASG_Configuration(ref Device, ref ASG_ProfileIn, ref ASG_ProfileOut, ref ASG_Info); //Apply the ASG mode configuration by calling this function

			double[] Frequency = new double[TraceInfo.FullsweepTracePoints];			 //Create an array to store a full range of frequency data
			float[] PowerSpec_dBm = new float[TraceInfo.FullsweepTracePoints];			 //Create an array to store a full range of amplitude data
			HtraApi.MeasAuxInfo_TypeDef MeasAuxInfo = new HtraApi.MeasAuxInfo_TypeDef(); //Auxiliary information for measurement data

			#endregion

			#region 3 Signal Output
			while (true)
			{
				Status = HtraApi.SWP_GetFullSweep(ref Device, Frequency, PowerSpec_dBm, ref MeasAuxInfo); //Retrieve trace data
			}
			#endregion

			#region 4 Close
			HtraApi.Device_Close(ref Device);
			#endregion
		}
	}
}
