#define EXAMPLE_MACRO_NAME
#include "htra_api.h"

int DSP_FMDemod();       // Perform FM demodulation on IQ data and play the demodulated audio.
int DSP_AMDemod();       // Perform AM demodulation on IQ data and play the demodulated audio.

void Device_Open_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo); // Exception handling during device opening
void SWP_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, SWP_Profile_TypeDef* SWP_ProfileIn, SWP_Profile_TypeDef* SWP_ProfileOut, SWP_TraceInfo_TypeDef* TraceInfo);				 // Exception handling during SWP mode configuration
void IQS_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, IQS_Profile_TypeDef* IQS_ProfileIn, IQS_Profile_TypeDef* IQS_ProfileOut, IQS_StreamInfo_TypeDef* StreamInfo);				 // Exception handling during IQS mode configuration
void DET_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, DET_Profile_TypeDef* DET_ProfileIn, DET_Profile_TypeDef* DET_ProfileOut, DET_StreamInfo_TypeDef* StreamInfo);				 // Exception handling during DET mode configuration
void RTA_Configuration_ErrorHandling(int Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, RTA_Profile_TypeDef* RTA_ProfileIn, RTA_Profile_TypeDef* RTA_ProfileOut, RTA_FrameInfo_TypeDef* FrameInfo);				 // Exception handling during RTA mode configuration
void SWP_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, SWP_Profile_TypeDef* SWP_ProfileIn, SWP_Profile_TypeDef* SWP_ProfileOut, SWP_TraceInfo_TypeDef* TraceInfo);	 // Exception handling for SWP mode functions other than device opening and configuration
void IQS_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, IQS_Profile_TypeDef* IQS_ProfileIn, IQS_Profile_TypeDef* IQS_ProfileOut, IQS_StreamInfo_TypeDef* StreamInfo); // Exception handling for IQS mode functions other than device opening and configuration
void DET_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, DET_Profile_TypeDef* DET_ProfileIn, DET_Profile_TypeDef* DET_ProfileOut, DET_StreamInfo_TypeDef* StreamInfo); // Exception handling for DET mode functions other than device opening and configuration
void RTA_ErrorHandlingExceptOpenAndConfiguration(int& Status, void** Device, int DevNum, BootProfile_TypeDef* BootProfile, BootInfo_TypeDef* BootInfo, RTA_Profile_TypeDef* RTA_ProfileIn, RTA_Profile_TypeDef* RTA_ProfileOut, RTA_FrameInfo_TypeDef* FrameInfo);	 // Exception handling for RTA mode functions other than device opening and configuration
