﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HTRA_CSharp_Examples
{
    class Device_GetDeviceInfo
    {
		public void Example()
		{
			//Model to DevName mapping
			Dictionary<ushort, string> ModelToDevName = new Dictionary<ushort, string>
			{
				{ 12, "E90 R2" },
				{ 13, "E90 R3" },
				{ 22, "E200 R2" },
				{ 23, "E200 R3" },
				{ 53, "N60 R4" },
				{ 54, "M60 R4" },
				{ 55, "N45 R4" },
				{ 56, "M80 R5" },
				{ 57, "M60 R5" },
				{ 58, "N60 R5" },
				{ 59, "N45 R5" },
				{ 91, "N400 R1" },
				{ 94, "N400 R2V2" }
			};
			#region 1 Open Device
			int apiVersion = HtraApi.Get_APIVersion();
			int major = 0, minor = 0, rev = 0;
			major = (apiVersion >> 16) & 0xffff;
			minor = (apiVersion >> 8) & 0xff;
			rev = apiVersion & 0xff;
			Console.WriteLine($"htra_api version: {major}.{minor}.{rev}"); //Print htra_api version

			int Status = 0;
			IntPtr Device = IntPtr.Zero;
			int DevNum = 0;

			HtraApi.BootProfile_TypeDef BootProfile = new HtraApi.BootProfile_TypeDef(); //Boot configuration																					 
			HtraApi.BootInfo_TypeDef BootInfo = new HtraApi.BootInfo_TypeDef();          //Boot info

			BootProfile.DevicePowerSupply = HtraApi.DevicePowerSupply_TypeDef.USBPortAndPowerPort; //Use USB data port and separate power port for dual power supply.

			//If the device data interface is USB, run directly. If it is Ethernet, change #if true to #if false
#if true
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.USB;
#else
			//Configure network-related parameters
			BootProfile.PhysicalInterface = HtraApi.PhysicalInterface_TypeDef.ETH;
			BootProfile.ETH_IPVersion = HtraApi.IPVersion_TypeDef.IPv4;
			BootProfile.ETH_RemotePort = 5000;
			BootProfile.ETH_ReadTimeOut = 5000;
			BootProfile.ETH_IPAddress[0] = 192;
			BootProfile.ETH_IPAddress[1] = 168;
			BootProfile.ETH_IPAddress[2] = 1;
			BootProfile.ETH_IPAddress[3] = 100;
#endif

			Status = HtraApi.Device_Open(ref Device, DevNum, ref BootProfile, ref BootInfo); //Open the device
			Console.WriteLine($"Device_Open: {Status}");

			//Print device information
			Console.WriteLine($"BusSpeed: {BootInfo.BusSpeed}"); //BootInfo.BusSpeed: 3 is USB3.0 and 2 is USB2.0
			Console.WriteLine($"Model: {BootInfo.DeviceInfo.Model},{ModelToDevName[BootInfo.DeviceInfo.Model]}");
			Console.WriteLine($"DeviceInfo.DeviceUID: {String.Format("{0:X}", BootInfo.DeviceInfo.DeviceUID)}");


			//Print MCU firmware version
			major = (int)(BootInfo.DeviceInfo.MFWVersion >> 16) & 0xffff;
			minor = (int)(BootInfo.DeviceInfo.MFWVersion >> 8) & 0xff;
			rev = (int)BootInfo.DeviceInfo.MFWVersion & 0xff;
			Console.WriteLine($"MCU Firmware: {major}.{minor}.{rev}");

			//Print FPGA firmware version
			major = (int)(BootInfo.DeviceInfo.FFWVersion >> 16) & 0xffff;
			minor = (int)(BootInfo.DeviceInfo.FFWVersion >> 8) & 0xff;
			rev = (int)BootInfo.DeviceInfo.FFWVersion & 0xff;
			Console.WriteLine($"FPGA Firmware: {major}.{minor}.{rev}");

			//If Device_Open returns non-zero, the program ends

			HtraApi.DeviceInfo_TypeDef DeviceInfo = new HtraApi.DeviceInfo_TypeDef();
			Status = HtraApi.Device_QueryDeviceInfo_Realtime(ref Device, ref DeviceInfo); //Query device information

			HtraApi.DeviceState_TypeDef DeviceState = new HtraApi.DeviceState_TypeDef();
			Status = HtraApi.Device_QueryDeviceState_Realtime(ref Device, ref DeviceState); //Query device state
			Console.WriteLine($"Device Temperature: {DeviceState.Temperature * 0.01}℃");

			#endregion

			#region 3 Close
			HtraApi.Device_Close(ref Device);
			Console.ReadLine();
			#endregion
		}
	}
}
