from htra_api import *

###Open Device###
Status = 0          #Function return value.
Device = c_void_p() #Memory address of the current device.
DevNum = c_int(0)   #Specify device number.

BootProfile = BootProfile_TypeDef() #Boot configuration structure, including physical interface, power supply mode, etc.
BootInfo = BootInfo_TypeDef()       #Boot information structure, including device information, USB rate, etc.

BootProfile.DevicePowerSupply = DevicePowerSupply_TypeDef.USBPortAndPowerPort #Use both USB data port and independent power port for power supply.
BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.USB                 #Use USB interface for data transmission.

#Configure ETH interface for network port devices
#BootProfile.PhysicalInterface = PhysicalInterface_TypeDef.ETH #Use network port for data transmission
#BootProfile.ETH_IPVersion = IPVersion_TypeDef.IPv4
#BootProfile.ETH_RemotePort = 5000
#BootProfile.ETH_ReadTimeOut = 10000
#BootProfile.ETH_IPAddress[0] = 192
#BootProfile.ETH_IPAddress[1] = 168
#BootProfile.ETH_IPAddress[2] = 1
#BootProfile.ETH_IPAddress[3] = 100

Status = dll.Device_Open(pointer(Device),DevNum,pointer(BootProfile),pointer(BootInfo)) #Open device.
if(Status == 0):
    print("Device is opened successfully")
else:
    print("Return other errors Status = {:d}".format(Status))

###Configuration Delivery###
SWP_ProfileIn = SWP_Profile_TypeDef()  #SWP input configuration, including start frequency, stop frequency, RBW, reference level, etc.
SWP_ProfileOut = SWP_Profile_TypeDef() #SWP output configuration.
TraceInfo = SWP_TraceInfo_TypeDef()    #Trace information under the current configuration, including trace points, frequency hopping points, etc.

dll.SWP_ProfileDeInit(pointer(Device),pointer(SWP_ProfileIn)) #Initialize relevant parameters in SWP mode.

SWP_ProfileIn.StartFreq_Hz = 9e3                        #Configure start frequency.
SWP_ProfileIn.StopFreq_Hz = 1e9                         #Configure stop frequency.
SWP_ProfileIn.RBW_Hz=50e3                               #Configure RBW.
SWP_ProfileIn.RBWMode = RBWMode_TypeDef.RBW_Manual      #Configure RBW mode.
SWP_ProfileIn.VBWMode = VBWMode_TypeDef.VBW_TenTimesRBW #Configure VBW.

Status = dll.SWP_Configuration(pointer(Device),pointer(SWP_ProfileIn),pointer(SWP_ProfileOut),pointer(TraceInfo))   #Deliver SWP mode configuration.

if(Status == 0):
    print("configuration delievery succeeded")
else:
    print("SWP_Configuration call is incorrect Status = {:d}".format(Status))

### Data Acquisition###
Frequency = (c_double * TraceInfo.FullsweepTracePoints)()      #Create frequency array.
PowerSpec_dBm = (c_float * TraceInfo.FullsweepTracePoints)()   #Create power array.
PartialFreq = (c_double * TraceInfo.PartialsweepTracePoints)() #Single frame frequency array.
PartialSpec = (c_float * TraceInfo.PartialsweepTracePoints)()  #Single frame power array.
HopIndex = c_int(0)                                            #Current frequency hopping point index.
FrameIndex = c_int(0)                                          #Current frame index.
MeasAuxInfo = MeasAuxInfo_TypeDef()                            #This structure stores auxiliary information of measurement data.

while True:
    for i in range(0,TraceInfo.TotalHops):
        Status = dll.SWP_GetPartialSweep(pointer(Device),PartialFreq,PartialSpec, pointer(HopIndex), pointer(FrameIndex),pointer(MeasAuxInfo))
        Frequency[i*TraceInfo.PartialsweepTracePoints:(i+1)*TraceInfo.PartialsweepTracePoints] = PartialFreq
        PowerSpec_dBm[i*TraceInfo.PartialsweepTracePoints:(i+1)*TraceInfo.PartialsweepTracePoints] = PartialSpec
    #Print data
    for item in PowerSpec_dBm:
        print(item)

###Close Device###
Status = dll.Device_Close(pointer(Device))